﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;


public enum State
{
    MENU,
    GAME,
    WIN3,
    WIN2,
    WIN1,
    LOSE,
    CREDIT,
    CONTROLE,
    FIN
}

public class StateMachine : MonoBehaviour
{
    public State state;

    public GameObject guiMenu;
    public GameObject guiGame;
    public GameObject guiWin3;
    public GameObject guiWin2;
    public GameObject guiWin1;
    public GameObject guiLose;
    public GameObject guiCredit;
    public GameObject guiFin;
    public GameObject guiControle;
    public ChooseColor poule;


    static public StateMachine instance;  //singleton
    public int monstretue = 0;

    void Awake()
    {
        if (instance != null) Debug.LogError("Double singleton!");
        instance = this;
    }

    void Start()
    {
        state = State.MENU;
    }
    void Update()
    {
        guiMenu.SetActive(state == State.MENU);
        guiGame.SetActive(state == State.GAME);
        guiWin3.SetActive(state == State.WIN3);
        guiWin2.SetActive(state == State.WIN2);
        guiWin1.SetActive(state == State.WIN1);
        guiLose.SetActive(state == State.LOSE);
        guiCredit.SetActive(state == State.CREDIT);
        guiControle.SetActive(state == State.CONTROLE);
        guiFin.SetActive(state == State.FIN);
    }

    public int vie = 3;
    public int level;

    public void SetState(State newState)
    {
        state = newState;
    }

    public void OnClickQuit()
    {
        Application.Quit();
    }

    public void OnClickCredit()
    {
        SetState(State.CREDIT);
    }
    public void OnClickControle()
    {
        SetState(State.CONTROLE);
    }

    public void OnClickMenu()
    {
        SetState(State.MENU);
    }
    public void OnClickPlay(int choice)
    {
        level = choice;
        vie = 3;
        poule.Color();
        SetState(State.GAME);

    }

    public void OnClickReplay()
    {
        vie = 3;
        poule.Color();
        SetState(State.GAME);
    }

    public void OnClickNext()
    {
        vie = 3;
        if (level == 3)
        {
            SetState(State.FIN);
        }
        else
        {
            level++;
            poule.Color();
            SetState(State.GAME);
        }
    }
}

